#include <windows.h>
#include <conio.h>
#include <stdio.h>
#include <cmath>
#include <time.h>
#include "hid.h"

#define uint8_t UINT8 
#define int8_t INT8 
#define uint16_t UINT16
#define int16_t INT16
	
#define VENDOR_ID 0x3EB
#define PRODUCT_ID 0x2013

unsigned char sequenceByte = 0;

HidDevice* device;

typedef struct {
  uint16_t temperature;
  int16_t x;
  int16_t y;
  int16_t z;
  uint16_t gpioInput;
} SlaveData;

void endianSwap(uint16_t& value)
{
	int low = value & 0xff;
	int high = (value >> 8) & 0xff;
	value = (low << 8) | high;
}

void endianSwap(int16_t& value)
{
	int low = value & 0xff;
	int high = (value >> 8) & 0xff;
	value = (low << 8) | high;
}

void sendMessage(uint16_t gpio)
{
	unsigned char message[64];
	message[0] = gpio & 0xff;
	message[1] = (gpio >> 8) & 0xff;
	device->sendMessage(message, 64);
	Sleep(100);
	device->readMessage(message, 64);
	SlaveData* slaveData = (SlaveData*) &message;
	endianSwap(slaveData->temperature);
	endianSwap(slaveData->x);
	endianSwap(slaveData->y);
	endianSwap(slaveData->z);
	endianSwap(slaveData->gpioInput);
	printf("temperature: %i, x: %i, y: %i, z: %i %08x\r\n", slaveData->temperature, slaveData->x, slaveData->y, slaveData->z, slaveData->gpioInput);
}

int main(int argc, char** argv)
{
	vector<HidDevice> devices = HidDevice::searchDevice(VENDOR_ID, PRODUCT_ID);
	if (devices.size() == 0) {
		printf("No I2C-Test hardware found");
		return -1;
	}
	device = &devices[0];

	int led = 1;
	bool continuus = false;
	while (1) {
		if (_kbhit()) {
			int c = _getch();
			switch (c) {
				case 'x':
					printf("led\n");
					if (led) {
						sendMessage(0x80);
					} else {
						sendMessage(0);
					}
					led = 1 - led;
					break;
				default:
					break;
			}
		}
		if (continuus) {
			time_t seconds;
			seconds = time(NULL);
			tm *ltm = localtime(&seconds);
			int minutes = ltm->tm_min;
			while (true) {
				seconds = time(NULL);
				ltm = localtime(&seconds);
				if (minutes != ltm->tm_min) break;
				Sleep(100);
			}
			char buf[256];
			sprintf(buf, "%02i:%02d:%02d\t%.2f", ltm->tm_hour, ltm->tm_min, ltm->tm_sec, 1);
			for (size_t i = 0; i < strlen(buf); i++) if (buf[i] == '.') buf[i] = ',';
			printf("%s\n", buf);
			fflush(stdout);
		}
		Sleep(100);
	}
	return 0;
}
